unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, BannerSoftware, TrialSoftware, StdCtrls, ExtCtrls, ShellAPI, jpeg;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    Image1: TImage;
    Panel3: TPanel;
    GroupBox1: TGroupBox;
    Memo1: TMemo;
    Button1: TButton;
    Label1: TLabel;
    TrialSoftware1: TTrialSoftware;
    BannerSoftware1: TBannerSoftware;
    procedure FormCreate(Sender: TObject);
    procedure BannerSoftware1ChangeFile(Sender: TObject; BannerIMG,
      BannerURL, BannerHINT: String);
    procedure Image1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  SiteURL: string;
  
implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     SiteURL := '';

     BannerSoftware1.DirectoryBannerStore := ExtractFilePath(Application.EXEName) + 'banner\';

     TrialSoftware1.Execute;
     BannerSoftware1.Execute;

     if TrialSoftware1.Status = stRegistered then
        begin
             Panel1.Visible := False;
        end;
end;

procedure TForm1.BannerSoftware1ChangeFile(Sender: TObject; BannerIMG,
  BannerURL, BannerHINT: String);
begin
     try
        Image1.Picture.LoadFromFile(BannerIMG);
        Image1.Hint := BannerHINT;
        SiteURL := BannerURL;
     finally

     end;
end;

procedure TForm1.Image1Click(Sender: TObject);
begin
     if SiteURL <> '' then
        begin
             ShellExecute(GetDesktopWindow,'open',PChar(SiteURL),nil,nil,SW_SHOWNORMAL);
        end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     TrialSoftware1.ShowWindow;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
     Form1.Close;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     BannerSoftware1.RemoveBanner;
end;

end.
